/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.core.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.image.decoders.GifDecoder;
import org.watermedia.core.tools.DataTool;

public class IOTool {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");

    public static boolean rmdirs(Path path) {
        return IOTool.rmdirs(path.toFile());
    }

    public static boolean rmdirs(File root) {
        File[] files = root.listFiles();
        if (files == null || files.length == 0) {
            return root.delete();
        }
        for (File f : files) {
            File[] childs = f.listFiles();
            if (childs != null && childs.length != 0 && !IOTool.rmdirs(f)) {
                return false;
            }
            if (f.delete()) continue;
            return false;
        }
        return true;
    }

    public static String readString(Path from) {
        String string;
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(from, new OpenOption[0]));
        try {
            byte[] bytes = DataTool.readAllBytes(in);
            string = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        in.close();
        return string;
    }

    public static String readString(File from) {
        return IOTool.readString(from.toPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifDecoder readGif(Path path) {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status != 0) throw new IOException("Failed to process GIF - Decoder status: " + status);
            GifDecoder gifDecoder = gif;
            return gifDecoder;
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed reading GIF from disk", (Throwable)e);
            return null;
        }
    }

    public static boolean writeData(File to, byte[] data) {
        return IOTool.writeData(to.toPath(), data);
    }

    public static boolean writeData(Path to, byte[] data) {
        boolean bl;
        to.getParent().toFile().mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(to.toFile()));
        try {
            os.write(data);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "Failed to write text file from disk", (Throwable)e);
                return false;
            }
        }
        os.close();
        return bl;
    }

    public static void un7zip(Path zipPath) throws IOException {
        IOTool.un7zip(zipPath, zipPath.getParent());
    }

    public static void un7zip(Path zipPath, Path destPath) throws IOException {
        throw new UnsupportedOperationException("Cannot extract 7z file, support was dropped");
    }

    public static void unzip(Path zipFilePath) throws IOException {
        IOTool.unzip(zipFilePath, zipFilePath.getParent());
    }

    public static void unzip(Path zipFilePath, Path destDirectory) throws IOException {
        WaterMedia.LOGGER.debug(IT, "Unzipping file from '{}' to directory '{}'", (Object)zipFilePath, (Object)destDirectory);
        if (zipFilePath.toString().endsWith(".7z")) {
            throw new IOException("Attempted to extract a 7z as a .zip");
        }
        File destDir = destDirectory.toFile();
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    IOTool.unzip$extract(zipIn, filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void unzip$extract(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            int read;
            byte[] bytesIn = new byte[4096];
            while ((read = zipIn.read(bytesIn)) != -1) {
                output.write(bytesIn, 0, read);
            }
        }
    }
}

